package game;



import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;

import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.Synthesizer;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.swing.JOptionPane;


public class AudioManager {
	
	
	private Sequencer sequencer;
	private Synthesizer synthesizer;
	
	private Sequence gameOverMusic;

	
	public Sequence getGameOverMusic() {
		return gameOverMusic;
	}

	public void setGameOverMusic(Sequence gameOverMusic) {
		this.gameOverMusic = gameOverMusic;
	}

	

	public Sequencer getSequencer() {
		return sequencer;
	}

	public void setSequencer(Sequencer sequencer) {
		this.sequencer = sequencer;
	}

	

	public Synthesizer getSynthesizer() {
		return synthesizer;
	}

	public void setSynthesizer(Synthesizer synthesizer) {
		this.synthesizer = synthesizer;
	}

	
	public Clip loadGivenClip(String fileName) throws UnsupportedAudioFileException, IOException, LineUnavailableException {
		
		Clip returnValue = null;
		
		AudioInputStream ais;
		
			ais = AudioSystem.getAudioInputStream(new File(fileName));
			AudioFormat af = ais.getFormat();
			
			if(af.getEncoding() == AudioFormat.Encoding.ALAW ||
					af.getEncoding() == AudioFormat.Encoding.ULAW ) {
				
				AudioFormat newFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED,
						af.getSampleRate(),
						af.getSampleSizeInBits() * 2,
						af.getChannels(),
						af.getFrameSize() * 2,
						af.getFrameRate(),
						true);
				
				ais = AudioSystem.getAudioInputStream(newFormat, ais);
				af = newFormat;
				
			}
			
			DataLine.Info inf = new DataLine.Info(Clip.class, af);
			
			if(!AudioSystem.isLineSupported(inf)) {
				JOptionPane.showMessageDialog(null, "ERROR:  The clip isn't supported!");
			}
			
			returnValue = (Clip) AudioSystem.getLine(inf);
			
			returnValue.open(ais);
			ais.close();
		
		
		return returnValue;
	}
	
	
	
	public Sequence loadGivenMidi(String fileName) {
		
		Sequence returnValue = null;
		
		if(sequencer == null) {
			initiateSequencerAndSynthesizer();
		}
		
		try {
			File theFile = new File(fileName);
			if(theFile.canRead()) {
				//System.out.println("could read the file");
			} else {
				//System.out.println("no can read file");
			}
			returnValue = MidiSystem.getSequence(theFile);
		} catch (InvalidMidiDataException e) {
			// TODO Auto-generated catch block
//			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
//			e.printStackTrace();
		}
		
		return returnValue;
		
		
		
	}
	
	public void initiateSequencerAndSynthesizer() {
		
		MidiSystem m;
		
		try {
			
			sequencer = MidiSystem.getSequencer();
			
			sequencer.open();
			
			if(!(sequencer instanceof Synthesizer)) {
				
				synthesizer = MidiSystem.getSynthesizer();
				synthesizer.open();
				
				sequencer.getTransmitter().setReceiver(synthesizer.getReceiver());
				
			} else {
				synthesizer = (Synthesizer) sequencer;
			}
			
			
		} catch (MidiUnavailableException e) {
			// TODO Auto-generated catch block
//			e.printStackTrace();
		}
		
		
		
		
	}
	
	
	public Clip loadGivenClipViaURL(String fileName) {
		
		Clip returnValue = null;
		
		AudioInputStream ais;
		try {
			ais = AudioSystem.getAudioInputStream(AudioManager.class.getResource(fileName));
			AudioFormat af = ais.getFormat();
			
			if(af.getEncoding() == AudioFormat.Encoding.ALAW ||
					af.getEncoding() == AudioFormat.Encoding.ULAW ) {
				
				AudioFormat newFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED,
						af.getSampleRate(),
						af.getSampleSizeInBits() * 2,
						af.getChannels(),
						af.getFrameSize() * 2,
						af.getFrameRate(),
						true);
				
				ais = AudioSystem.getAudioInputStream(newFormat, ais);
				af = newFormat;
				
			}
			
			DataLine.Info inf = new DataLine.Info(Clip.class, af);
			
			if(!AudioSystem.isLineSupported(inf)) {
				JOptionPane.showMessageDialog(null, "ERROR:  The clip isn't supported!");
			}
			
			returnValue = (Clip) AudioSystem.getLine(inf);
			returnValue.open(ais);
			ais.close();
			
		} catch (UnsupportedAudioFileException e) {
			// TODO Auto-generated catch block
			//System.err.println("unable to load file:  <<" + fileName + ">>");
//			e.printStackTrace();
			return null;
		} catch (IOException e) {
			// TODO Auto-generated catch block
			//System.err.println("unable to load file:  <<" + fileName + ">>");
//			e.printStackTrace();
			return null;
		} catch (LineUnavailableException e) {
			// TODO Auto-generated catch block
			//System.err.println("unable to load file:  <<" + fileName + ">>");
//			e.printStackTrace();
			return null;
		} catch (NullPointerException e) {
			// TODO Auto-generated catch block
			//System.err.println("unable to load file:  <<" + fileName + ">>");
//			e.printStackTrace();
			return null;
		}
		
		return returnValue;
	}
	
	
	public static void retrieveFileLength(String fileName, HashMap<String, Long> fileLengths) throws UnsupportedAudioFileException, IOException, LineUnavailableException {
		
		Clip returnValue = null;
		
		
		if(fileLengths.containsKey(fileName))
			return;
		
		FileInputStream fis = new FileInputStream(new File(fileName));
		
		long lengthOfFile = 0L;
		
		while(fis.read() != -1)
			lengthOfFile++;
		
		fis.close();
		
		fileLengths.put(fileName, lengthOfFile);
		
	}
	
}
